/*
 * Decompiled with CFR 0.152.
 */
package ca.fxco.moreculling.mixin.blocks;

import ca.fxco.moreculling.MoreCulling;
import ca.fxco.moreculling.api.block.LeavesCulling;
import ca.fxco.moreculling.api.block.MoreBlockCulling;
import ca.fxco.moreculling.config.option.LeavesCullingMode;
import ca.fxco.moreculling.utils.CullingUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={LeavesBlock.class}, priority=1220)
public class LeavesBlock_typesMixin
extends Block
implements MoreBlockCulling,
LeavesCulling {
    @Shadow
    @Final
    public static IntegerProperty DISTANCE;

    public LeavesBlock_typesMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public boolean skipRendering(BlockState state, BlockState stateFrom, Direction direction) {
        if (MoreCulling.CONFIG.leavesCullingMode == LeavesCullingMode.FAST || CullingUtils.areLeavesOpaque() || MoreCulling.CONFIG.leavesCullingMode == LeavesCullingMode.VERTICAL && direction.getAxis() == Direction.Axis.Y) {
            return stateFrom.getBlock() instanceof LeavesCulling || super.skipRendering(state, stateFrom, direction);
        }
        return super.skipRendering(state, stateFrom, direction);
    }

    @Override
    public boolean moreculling$usesCustomShouldDrawFace(BlockState state) {
        return MoreCulling.CONFIG.leavesCullingMode != LeavesCullingMode.DEFAULT;
    }

    @Override
    public Optional<Boolean> moreculling$customShouldDrawFace(BlockGetter view, BlockState thisState, BlockState sideState, BlockPos thisPos, BlockPos sidePos, Direction side) {
        return switch (MoreCulling.CONFIG.leavesCullingMode) {
            case LeavesCullingMode.STATE -> {
                if (sideState.getBlock() instanceof LeavesBlock && (Integer)sideState.getValue((Property)DISTANCE) % 3 != 1) {
                    yield Optional.of(false);
                }
                yield Optional.empty();
            }
            case LeavesCullingMode.CHECK -> CullingUtils.shouldDrawFaceCheck(view, sideState, thisPos, sidePos, side);
            case LeavesCullingMode.GAP -> CullingUtils.shouldDrawFaceGap(view, sideState, sidePos, side);
            case LeavesCullingMode.DEPTH -> CullingUtils.shouldDrawFaceDepth(view, sideState, sidePos, side);
            case LeavesCullingMode.RANDOM -> CullingUtils.shouldDrawFaceRandom(view, sideState, sidePos, side);
            default -> Optional.empty();
        };
    }

    @Override
    public boolean moreculling$cantCullAgainst(BlockState state, Direction side) {
        return true;
    }
}

